% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETRep_Functions.R
\name{intrinsic_mean_tube}
\alias{intrinsic_mean_tube}
\title{Calculate Intrinsic Mean of ETReps}
\usage{
intrinsic_mean_tube(tubes, type = "sizeAndShapeAnalysis", plotting = TRUE)
}
\arguments{
\item{tubes}{List of ETReps.}

\item{type}{String, "ShapeAnalysis" or "sizeAndShapeAnalysis" (default is "sizeAndShapeAnalysis").}

\item{plotting}{Logical, enables visualization of the mean (default is TRUE).}
}
\value{
List representing the mean ETRep.
}
\description{
Computes the intrinsic mean of a set of ETReps. The computation involves transforming the non-convex hypertrumpet space into a convex space, calculating the mean in this transformed space, and mapping the result back to the original hypertrumpet space.
}
\examples{
#Example 1
# Load tubes
data("tube_A")
data("tube_B")
intrinsic_mean<-
  intrinsic_mean_tube(tubes = list(tube_A,tube_B),
                      plotting = FALSE)
# Plotting
\dontrun{
plot_Elliptical_Tube(tube = intrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)
 }

#Example 2
data("simulatedColons")
intrinsic_mean<-
  intrinsic_mean_tube(tubes = simulatedColons,
                      plotting = FALSE)
# Plotting
\dontrun{
plot_Elliptical_Tube(tube = intrinsic_mean,
                     plot_frames = FALSE,
                     plot_skeletal_sheet = FALSE,
                     plot_r_project = FALSE,
                     plot_r_max = FALSE,
                     add = FALSE)
 }
}
\references{
Taheri, M., Pizer, S. M., & Schulz, J. (2024). "The Mean Shape under the Relative Curvature Condition." arXiv.
\doi{10.48550/arXiv.2404.01043}

Taheri Shalmani, M. (2024). "Shape Statistics via Skeletal Structures." University of Stavanger.
\doi{10.13140/RG.2.2.34500.23685}
}
