% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msa.R
\name{msa.tree}
\alias{msa.tree}
\title{Infer a tree based on a MSA}
\usage{
msa.tree(data, outgroup = 'any')
}
\arguments{
\item{data}{input data must be a dataframe where each row corresponds to a protein and each column to a species.}

\item{outgroup}{when a rooted tree is desired, indicate the species to be used as outgroup.}
}
\value{
A list containing the (i) MSA, (ii) the distance matrix and (iii) the tree.
}
\description{
Infers a tree base on a MSA.
}
\details{
The input data has the same format that the input data used for EnvNJ or SVD-n-Gram methods. Thus, the name of columns must correspond to that of species.
}
\examples{
\dontrun{
data(bovids)
msa.tree(bovids)}
}
\seealso{
msa.merge
}
