% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImpFeatures.R
\name{ImpFeatures}
\alias{ImpFeatures}
\title{Important Features}
\usage{
ImpFeatures(Fastafile,Species)
}
\arguments{
\item{Fastafile}{Sequence file in .fasta format}
\item{Species}{Model organism}
}
\value{
test_data_input: A matrix containing important features for prediction
}
\description{
Find out the most suitable features for predicting sequences with 6mA sites.
}
\examples{
\donttest{
library(EpiSemble)
data<-system.file("exdata/test.fasta", package = "EpiSemble")
imp<-ImpFeatures(Fastafile=data, Species="Rice")
}
}
\references{
Chen, W., Lv, H., Nie, F., & Lin, H. (2019). i6mA-Pred: identifying DNA N6-methyladenine 	sites in the rice genome. Bioinformatics, 35(16), 2796-2800.
}
