% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_pca_results.R
\name{combine_data}
\alias{combine_data}
\title{Import depth statistics and combine with PC scores}
\usage{
combine_data(
  tag_vector = tag_list,
  data_folder = NULL,
  pc_scores = scores,
  output = FALSE,
  output_folder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{tag_vector}{A character vector of tag IDs. E.g. 'c("123456", "456283",
"AB98XJ").}

\item{data_folder}{Parent folder path with separate folders for each tag
data. E.g. "C:/Tag data". Defaults to 'data_dir'}

\item{pc_scores}{Data frame of principal component scores extracted through
PCA on wavelet statistics. Output of 'pca_scores()' function.}

\item{output}{Logical. If TRUE, output is saved to \code{output_folder}.
Defaults to FALSE.}

\item{output_folder}{Output folder path. If \code{output = TRUE},
\code{output_folder} must be provided. Defaults to NULL.}

\item{verbose}{Logical. If TRUE, progress messages are shown. Defaults to FALSE.}
}
\value{
A data frame containing the combined depth statistics and principal
component scores from each of the tags listed in tag_vector
}
\description{
This function imports the depth statistics from each of the tags listed in
tag_vector, and outputs a combined data frame then combines the depth
statistics from each tag with the principal component scores, and outputs a
data frame with the appropriate unique_tag_ID if necessary, ready for use in
k-means clustering.
}
\examples{
# Set file path
filepath <- system.file("extdata", package = "FishDiveR")

# Load pc_results
pc_scores <- readRDS(file.path(filepath, "data/4_PCA/pc_scores.rds"))

# Run combine_data function
combined_stats <- combine_data(
  tag_vector = "data",
  data_folder = filepath,
  pc_scores = pc_scores,
  output = TRUE,
  output_folder = tempdir(),
  verbose = TRUE
)

}
