% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.taxonomy.R
\name{sim.anagenetic.species}
\alias{sim.anagenetic.species}
\title{Simulate anagenetic species on a taxonomy object}
\usage{
sim.anagenetic.species(tree, species, lambda.a)
}
\arguments{
\item{tree}{Phylo object.}

\item{species}{Taxonomy object.}

\item{lambda.a}{Rate of anagenetic speciation. Default = 0.}
}
\value{
Object of class taxonomy.
}
\description{
Simulate anagenetic species on a taxonomy object
}
\examples{
t = ape::rtree(10)
sp = sim.taxonomy(t, 1)
sim.anagenetic.species(t, sp, 0.1)

}
\seealso{
\code{\link{taxonomy}}
}
