% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_graphGIMMEgVAR.R
\name{graphKappa}
\alias{graphKappa}
\title{GIMMEgVAR: GraphGIMMEgVAR}
\usage{
graphKappa(
  outputPathGIMMEgVAR,
  gimmeGVARThreshold,
  pathProportionKappa,
  lableNames,
  groupKappa
)
}
\arguments{
\item{outputPathGIMMEgVAR}{Directory where network graphs will be saved.}

\item{gimmeGVARThreshold}{The cutoff value for group-level paths. Defaults to .50, indicating
that a path must be non-zero across >= .50% of individuals to be
included as a group-level path.}

\item{pathProportionKappa}{The proportion of individuals identified as having a path in the Kappa
matrix.  Used to determine group-level paths in the final group Kappa network.}

\item{lableNames}{Vector of names used to label nodes in Network graph. Defaults to variable names if no
vector is supplied.}

\item{groupKappa}{Matrix that identifies the presence of a group path in the Kappa matrix. 0 indicates no
group path present, 1 indicates group path present.}
}
\description{
Produces network graphs for beta and kappa matrices
as .png files.
}
\details{
Group and individual network paths are overlayed to form
a single network graph for each matrix, respectively.

Kappa matrix is depicted using solid lines, beta network is depicted using dashed lines.
In both networks, group paths appear as black lines. Individual paths appear as light grey lines.

For individual paths, line thickness is weighted by the proportion of individuals with paths
present.
}
