% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{icd_meta_chapters}
\alias{icd_meta_chapters}
\title{data.frame containing metadata for the ICD-10-GM chapters}
\format{
An object of class \code{data.frame} with 440 rows and 4 columns.
}
\source{
The source data was downloaded from the official download centre
of the German Institute for Medical Documentation and Information (DIMDI).
See also \url{https://www.dimdi.de/dynamic/en/classifications/icd/icd-10-gm/tabular-list/structure/}
}
\usage{
icd_meta_chapters
}
\description{
The ICD chapters group codes according to their aetiology.
}
\details{
\describe{
\item{year}{Year of validity (from 2004)}
\item{chapter}{Chapter number (arabic numerals)}
\item{chapter_roman}{Chapter number (Roman numerals)}
\item{chapter_label}{Label for the chapter}
}
}
\seealso{
Other ICD-10-GM metadata: 
\code{\link{icd_meta_blocks}},
\code{\link{icd_meta_codes}},
\code{\link{icd_meta_transition}}
}
\concept{ICD-10-GM metadata}
\keyword{datasets}
