## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7,
  fig.height = 5
)

## -----------------------------------------------------------------------------
library(IPAG)
data(Beauty)

## -----------------------------------------------------------------------------
str(Beauty)

## -----------------------------------------------------------------------------
mean_ci(Beauty$score)

## -----------------------------------------------------------------------------
mean_ci(Beauty$bty_avg)

## -----------------------------------------------------------------------------
score_female <- Beauty$score[Beauty$gender == "female"]
score_male <- Beauty$score[Beauty$gender == "male"]

mean_diff_ci(score_male, score_female)

## -----------------------------------------------------------------------------
bty_female <- Beauty$bty_avg[Beauty$gender == "female"]
bty_male <- Beauty$bty_avg[Beauty$gender == "male"]

mean_diff_ci(bty_male, bty_female)

## -----------------------------------------------------------------------------
high_score <- sum(Beauty$score > 4)
total <- nrow(Beauty)

prop_ci(trials = total, successes = high_score)

## -----------------------------------------------------------------------------
# Create categorical variables
Beauty$high_beauty <- Beauty$bty_avg > median(Beauty$bty_avg)
Beauty$high_eval <- Beauty$score > 4

# Contingency table
table_data <- table(Beauty$high_beauty, Beauty$high_eval)
print(table_data)

## -----------------------------------------------------------------------------
# Extract table cells
a <- table_data[2, 2]  # High beauty AND high evaluation
b <- table_data[2, 1]  # High beauty AND low evaluation
c <- table_data[1, 2]  # Low beauty AND high evaluation
d <- table_data[1, 1]  # Low beauty AND low evaluation

oddsratio_ci(a = a, b = b, c = c, d = d)

## -----------------------------------------------------------------------------
linear_regress(score ~ bty_avg, data = Beauty)

## -----------------------------------------------------------------------------
linear_regress(score ~ bty_avg + age + gender, data = Beauty)

## -----------------------------------------------------------------------------
linear_regress(score ~ bty_avg + age + gender + rank + cls_perc_eval + cls_students, 
               data = Beauty)

## -----------------------------------------------------------------------------
# Lower level courses
Beauty_lower <- Beauty[Beauty$cls_level == "lower", ]
linear_regress(score ~ bty_avg, data = Beauty_lower)

# Upper level courses
Beauty_upper <- Beauty[Beauty$cls_level == "upper", ]
linear_regress(score ~ bty_avg, data = Beauty_upper)

## -----------------------------------------------------------------------------
# Male professors
Beauty_male <- Beauty[Beauty$gender == "male", ]
linear_regress(score ~ bty_avg, data = Beauty_male)

# Female professors
Beauty_female <- Beauty[Beauty$gender == "female", ]
linear_regress(score ~ bty_avg, data = Beauty_female)

## -----------------------------------------------------------------------------
mean_ci(Beauty$score, level = 0.95)

## -----------------------------------------------------------------------------
linear_regress(score ~ bty_avg + gender, data = Beauty, level = 0.95)

## -----------------------------------------------------------------------------
# Scatter plot
plot(Beauty$bty_avg, Beauty$score,
     xlab = "Average beauty rating",
     ylab = "Evaluation score",
     main = "Relationship between beauty and evaluation",
     pch = 16, col = rgb(0, 0, 0, 0.3))

# Add regression line
abline(lm(score ~ bty_avg, data = Beauty), col = "red", lwd = 2)

## -----------------------------------------------------------------------------
# Score comparison by gender
boxplot(score ~ gender, data = Beauty,
        xlab = "Gender",
        ylab = "Evaluation score",
        main = "Distribution of scores by gender",
        col = c("pink", "lightblue"))

