% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gk.R
\name{GKIndex}
\alias{GKIndex}
\title{Compute the Geary-Khamis index}
\usage{
GKIndex(
  x,
  pvar,
  qvar,
  pervar,
  prodID,
  sample = "",
  window,
  splice = "mean",
  imputePrices = NULL,
  solveMethod = "inverse",
  tolerance = 1/1000000000000,
  maxIter = 100
)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}

\item{sample}{set to "matched" to only use products that occur
across all periods in a given window. Default is not to match.}

\item{window}{An integer specifying the length of the window.}

\item{splice}{the splicing method to use to extend the index. Valid methods are
window, movement, half, mean, fbew, fbmw, wisp, hasp or mean_pub. The default is mean.
See details for important considerations when using fbew and fbmw.}

\item{imputePrices}{the type of price imputation to use for missing prices.
Currently only "carry" is supported to used carry-forward/carry-backward prices.
Default is NULL to not impute missing prices.}

\item{solveMethod}{the method to use to solve for the quality adjustment factors
and the price levels. "inverse" uses a matrix inverse operation, is much more efficient, but
may not work if there are many missing observations.
"iterative" iterates between the equations for the quality adjustment factors and price levels
and is much slower, but can be used even when there are a large number of missing observations.}

\item{tolerance}{the tolerance for the iterative solving method. Smaller numbers will produce more
accurate results, but take more iterations. Default is 1/1e12, which may be a little larger
than machine precision, given by .Machine$double.eps.}

\item{maxIter}{the maximum number of iterations for the iterative solving method.}
}
\description{
Compute the Geary-Khamis index
}
\details{
The splicing methods are used to update the price index when new data become
available without changing prior index values. The window, movement, half and mean splices
use the most recent index value as the base period, which is multiplied by a price movement
computed using new data. The fbew (Fixed Base Expanding Window) and fbmw (Fixed Base Moving
Window) use a fixed base onto which the price movement using new data is applied. The base
period is updated periodically. IndexNumR calculates which periods are the base periods using
\code{seq(from = 1, to = n, by = window - 1)}, so the data must be set up correctly and the
right window length chosen. For example, if you have monthly data and want December
of each year to be the base period, then the first period in the data must be December
and the window must be set to 13.

It is recommended to use the matrix inverse method of solving the GK equations (the default)
because the performance difference can be significant. If the matrix inverse method does
not work then switch to the iterative method. The tolerance and maximum number of iterations
in the iterative method can be adjusted to balance performance and precision.
}
\examples{
# compute a Geary-Khamis index with mean splicing
GKIndex(CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", window=11, splice = "mean")
}
\references{
Ivancic, L., W.E. Diewert and K.J. Fox (2011), "Scanner Data,
Time Aggregation and the Construction of Price Indexes", Journal of
Econometrics 161, 24-35.

Geary, R. G. 1958. “A Note on Comparisons of Exchange Rates and Purchasing Power Between
Countries.” Journal of the Royal Statistical Society Series A 121: 97–99.

Khamis, S. H. 1970. “Properties and Conditions for the Existence of a New Type of Index Number.”
Sankhya: The Indian Journal of Statistics, Series B (1960-2002) 32: 81–98.
}
