% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dominicks.R
\name{dominicksData}
\alias{dominicksData}
\title{Get data from the Dominicks dataset}
\usage{
dominicksData(x, movementcsv = NULL, UPCcsv = NULL)
}
\arguments{
\item{x}{the name of the category to retrieve, see details for list.}

\item{movementcsv}{the path to the movement csv file for one product category. The default is NULL,
which downloads the file from the website.}

\item{UPCcsv}{the path to the UPC csv file for one product category. The default is NULL,
which downloads the file from the website.}
}
\description{
The Dominicks Scanner data, provided by the University of Chicago Booth School of Business,
contains around 5 years of product-level
data from over 100 stores, collected from 1989-1994. The data consist
of a UPC file that contains information on the products, and a
movement file that contains the information on prices and sales. For
a complete description of the data, see
\href{https://www.chicagobooth.edu/research/kilts/research-data/dominicks}{Dominicks data website}
and the
\href{https://www.chicagobooth.edu/-/media/enterprise/centers/kilts/datasets/dominicks-dataset/dominicks-manual-and-codebook_kiltscenter}{Dominicks data user manual}.
This function downloads and merges the movement and UPC files, then merges the
result with data detailing the dates of each of the weeks in the movement file.
}
\details{
The following transformations are performed on the data:
\itemize{
    \item The quantity variable is set to MOVE, which is the number of individual units sold
    \item The price variable is set to PRICE/QTY, which is the unit price. This accounts
    for the fact that sometimes products are sold in bundles (e.g., two-for-one promotions).
    \item expenditure is given by PRICE*MOVE/QTY.
    \item All observations where the variable OK equals 0, or price is less than or equal to 0, are dropped.
}

If you have already downloaded the movement and UPC csv files for a category from
the website, then you can pass the file paths of those files to the function
and just have it combine them with the weeks dataset. The default is to download
the files for you from the website.

The products available are:
\itemize{
    \item Analgesics
    \item Bath Soap
    \item Beer
    \item Bottled Juices
    \item Cereals
    \item Cheeses
    \item Cigarettes
    \item Cookies
    \item Crackers
    \item Canned Soup
    \item Dish Detergent
    \item Front-end-candies
    \item Frozen Dinners
    \item Frozen Entrees
    \item Frozen Juices
    \item Fabric Softeners
    \item Grooming Products
    \item Laundry Detergents
    \item Oatmeal
    \item Paper Towels
    \item Refrigerated Juices (not currently available)
    \item Soft Drinks
    \item Shampoos
    \item Snack Crackers
    \item Soaps
    \item Toothbrushes
    \item Canned Tuna
    \item Toothpastes
    \item Bathroom Tissues
}
}
\examples{
\dontrun{
analgesics <- dominicksData("Analgesics")
}
}
\references{
James M. Kilts Center, University of Chicago Booth School of Business
}
