% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_test.R
\name{hybrid_test}
\alias{hybrid_test}
\title{Tests for the multivariate goodness-of-fit problem via twosample tests}
\usage{
hybrid_test(
  x,
  rnull,
  phat = function(x) -99,
  nMC = 1,
  TS,
  TSextra,
  B = 1000,
  maxProcessor,
  doMethods = "all"
)
}
\arguments{
\item{x}{a matrix with the data set}

\item{rnull}{routine to generate data under the null hypothesis.}

\item{phat}{=function(x) -99 parameter estimation, if needed.}

\item{nMC}{=1 sample size of Monte Carlo data set, if it is a number nMC<=10  sample size used will be nMC*sample size of x.}

\item{TS}{user supplied function to find test statistics, if any.}

\item{TSextra}{(optional) list passed to TS, if needed.}

\item{B}{=5000  number of simulation runs. If B=0 the routine returns the test statistics.}

\item{maxProcessor}{number of processors to use in parallel processing.}

\item{doMethods}{="all", a vector of codes for the methods to include or all of them.}
}
\value{
A list with vectors of test statistics and p.values
}
\description{
This function runs a number of goodness-of-fit tests using Rcpp and parallel computing
by generating a Monte Carlo data set and then running a twosample test.
}
\details{
For details on the usage of this routine consult the vignette with vignette("MDgof-hybrid","MDgof-hybrid")
}
\examples{
# All examples are run with B=20 and maxProcessor=1 to pass CRAN checks.
# Tests to see whether data comes from a bivariate standard normal distribution, 
# without parameter estimation.
rnull=function() mvtnorm::rmvnorm(100, c(0, 0))
x=rnull()
hybrid_test(x, rnull, B=20, maxProcessor = 1)
# Tests to see whether data comes from a standard normal distribution, 
# with mean parameter estimated.
rnull=function(p) mvtnorm::rmvnorm(100, p)
phat=function(x) apply(x, 2, mean)  
x=rnull(c(0,1))
hybrid_test(x, rnull, phat, B=20, maxProcessor = 1)
# Example of a discrete model, without parameter estimation
# X~Bin(5, 0.5), Y|X=x~Bin(4, 0.5+x/100)
rnull=function() {
  x=rbinom(1000, 5, 0.5)
  y=rbinom(1000, 4, 0.5)
  MDgof::sq2rec(table(x, y))
}
x=rnull()
hybrid_test(x, rnull, B=50, maxProcessor = 1)
# Example of a discrete model, with parameter estimation
# X~Bin(5, p), Y|X=x~Bin(4, 0.5+x/100)
rnull=function(p) {
  x=rbinom(1000, 5, p)
  y=rbinom(1000, 4, 0.5+x/100)
  MDgof::sq2rec(table(x, y))
}
phat=function(x) {
  tx=tapply(x[,3], x[,1], sum)
  p1=mean(rep(as.numeric(names(tx)), times=tx))/5
  p1
}
x=rnull(0.5)
hybrid_test(x, rnull, phat, B=20, maxProcessor = 1)
}
