% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_din.R
\name{get_hc_din}
\alias{get_hc_din}
\title{Get All DINs from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_din()
}
\value{
A tibble with a single column:
\itemize{
  \item \code{din}: The Drug Identification Number
}
}
\description{
Retrieves all Drug Identification Numbers (DINs) from the Health Canada
Drug Product Database (DPD) using the RESTful API endpoint \code{/drug/drugproduct}.

Only the DIN column is returned, renamed as \code{din} for convenience.
}
\details{
This function sends a GET request to the Health Canada Drug Product Database API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and respects a rate limit between successive API requests.

If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  get_hc_din()
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}, \code{\link[dplyr]{rename}}
}
