% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{HermiteCoeff}
\alias{HermiteCoeff}
\title{Coefficients of Hermite polynomials}
\usage{
HermiteCoeff(Type, N, d = NULL)
}
\arguments{
\item{Type}{A character string specifying the type of Hermite polynomial. Must be either "Univariate" or "Multivariate".}

\item{N}{The order of polynomial. Required for both types.}

\item{d}{The dimension of the d-variate X. Required only for multivariate type.}
}
\value{
For `Type = "Univariate"`, returns a vector of coefficients of \eqn{x^N}, \eqn{x^{N-2}}, etc.
For `Type = "Multivariate"`, returns a list of matrices of coefficients for the d-variate polynomials from 1 to N.
}
\description{
Provides the coefficients of Hermite polynomials, either univariate or multivariate.
}
\examples{
# Univariate example
H_uni <- HermiteCoeff(Type = "Univariate", N = 5)

# Multivariate example
N <- 5; d <- 3
H_multi <- HermiteCoeff(Type = "Multivariate", N = N, d = d)
X <- c(1:3)
X3 <- kronecker(X, kronecker(X, X))
X5 <- kronecker(X3, kronecker(X, X))
Idv <- as.vector(diag(d)) # vector of variance matrix
# value of H5 at X is
vH5 <- H_multi[[1]] \%*\% X5 + H_multi[[2]] \%*\% kronecker(Idv, X3) +
  H_multi[[3]] \%*\% kronecker(kronecker(Idv, Idv), X)
}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear, Springer 2021. Sections 4.4 (4.24) and 4.6.2, p. 223, Remark 4.8
}
\seealso{
Other Hermite Polynomials: 
\code{\link{HermiteCov12}()},
\code{\link{HermiteN}()},
\code{\link{HermiteN2X}()}
}
\concept{Hermite Polynomials}
