% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{SymIndx}
\alias{SymIndx}
\title{Symmetrizing vector}
\usage{
SymIndx(x, d, n)
}
\arguments{
\item{x}{the vector  to be symmetrized of dimension d^n}

\item{d}{size of the single vectors in the product}

\item{n}{power of the T-product}
}
\value{
A vector with the symmetrized version of x of dimension d^n
}
\description{
Vector symmetrizing a T-product of vectors of the same dimension d.
Produces the same results as SymMatr
}
\examples{
a<-c(1,2)
b<-c(2,3)
c<-kronecker(kronecker(a,a),b)
## The symmetrized version of c is
SymIndx(c,2,3)


}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.Section 1.3.1 Symmetrization, p.14. (1.29)
}
\seealso{
Other Matrices and commutators: 
\code{\link{EliminIndx}()},
\code{\link{EliminMatr}()},
\code{\link{MargMomCum}()},
\code{\link{QplicIndx}()},
\code{\link{QplicMatr}()},
\code{\link{SymMatr}()}
}
\concept{Matrices and commutators}
