\docType{package}
\name{NMA-package}
\alias{NMA-package}
\title{The 'NMA' package.}
\description{
Network meta-analysis tools based on contrast-based approach using the multivariate meta-analysis and meta-regression models (Noma et al., 2025). Comprehensive analysis tools for network meta-analysis and meta-regression (e.g., synthesis analysis, ranking analysis, and creating league table) are available through simple commands. For inconsistency assessment, the local and global inconsistency tests based on the Higgins' design-by-treatment interaction model are available. In addition, the side-splitting methods and Jackson's random inconsistency model can be applied. Standard graphical tools for network meta-analysis, including network plots, ranked forest plots, and transitivity analyses, are also provided. For the synthesis analyses, the Noma-Hamura's improved REML (restricted maximum likelihood)-based methods (Noma et al. (2023ab)) are adopted as the default methods.
}
\references{
Higgins, J. P., Jackson, D., Barrett, J. K., Lu, G., Ades, A. E., and White, I. R. (2012). Consistency and inconsistency in network meta-analysis: concepts and models for multi-arm studies. \emph{Research Synthesis Methods} \strong{3}, 98-110.

Nikolakopoulou, A., White, I. R., and Salanti, G. (2021). Network meta-analysis. In: Schmid CH, Stijnen T, White IR, eds. \emph{Handbook of Meta-Analysis}. CRC Press; pp. 187-217.

Noma, H. (2024a). Sidesplitting using network meta-regression. \emph{Japanese Journal of Biometrics} \strong{44}, 107-118.

Noma, H. (2024b). Within-study covariance estimators for network meta-analysis with contrast-based approach. \emph{Japanese Journal of Biometrics} \strong{44}, 119-126.

Noma, H., Hamura, Y., Gosho, M., and Furukawa, T. A. (2023a). Kenward-Roger-type corrections for inference methods of network meta-analysis and meta-regression. \emph{Research Synthesis Methods} \strong{14}, 731-741.

Noma, H., Hamura, Y., Sugasawa, S., and Furukawa, T. A. (2023b). Improved methods to construct prediction intervals for network meta-analysis. \emph{Research Synthesis Methods} \strong{14}, 794-806.

Noma, H. and Maruo, K. (2025). Network meta-analysis combining survival and count outcome data: A simple frequentist approach. medRxiv, \doi{https://doi.org/10.1101/2025.01.23.25321051}.

Noma, H., Maruo, K., Tanaka, S. and Furukawa, T. A. (2025). NMA: Network meta-analysis based on multivariate meta-analysis and meta-regression models in R. medRxiv, \doi{https://doi.org/10.1101/2025.09.15.25335823}.

Noma, H., Tanaka, S., Matsui, S., Cipriani, A., and Furukawa, T. A. (2017). Quantifying indirect evidence in network meta-analysis. \emph{Statistics in Medicine} \strong{36}, 917-927.

Salanti, G. (2012). Indirect and mixed-treatment comparison, network, or multiple-treatments meta-analysis: many names, many benefits, many concerns for the next generation evidence synthesis tool. \emph{Research Synthesis Methods} \strong{3}, 80-97. 

White, I. R., Barrett, J. K., Jackson, D., and Higgins, J. P. (2012). Consistency and inconsistency in network meta-analysis: model estimation using multivariate meta-regression. \emph{Research Synthesis Methods} \strong{3}, 111-125.
}
