% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmplot.ncat.R
\name{nmplot.ncat}
\alias{nmplot.ncat}
\title{Create plots of the dose and the response differentiated by specified
variables}
\usage{
nmplot.ncat(data.nm, data.control, id, nano, response, dose, end,
  end.cat, unit, unit.cat,  cat, x.cat, type=c("dose","log"),
  control.opt=c("same","all"), nrow=1, ncol=1)
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{response}{Response (endpoint value)}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{cat}{Plot is generated for every unique value of \code{cat}}

\item{x.cat}{Variable used to differentiate the colour of the data points in
the plot(s)}

\item{type}{Type of the dose to be plotted ("\code{dose}" for dose and
"\code{log}" for log(dose))}

\item{control.opt}{Option for the control doses. If only control doses with
the same unit of measurement as the non-control ones are included, then
specify "\code{same}" in the \code{control.opt}. If all control doses with
any units of measurement are included, then specify "\code{all}".}

\item{nrow}{Number of rows in the plotting space (default is 1)}

\item{ncol}{Number of columns in the plotting space (default is 1)}
}
\value{
This function produces dose-response plots for every unique value of
  a certain variable, with different colours of data points based on the
  value of another variable
}
\description{
This function generates scatter plots of the dose and the response for every
unique value of a certain variable, with the colour of the data points
differentiated according to the value of another variable.
}
\details{
\itemize{
\item{This function generates plots for each nanomaterial in the dataset. The
different types of nanomaterials are identified by their names. Therefore, if
some control values are named differently (see: \code{\link{geninvitro}}
dataset and the \code{Examples}), a separate dataset containing only these
values first needs to be created. Controls in the new dataset can be linked
to the non-control observations belonging to the same experiment through the
identifier of the experiment (the linking is performed inside this function).
In this situation, it is necessary to have an indicator that can identify
different experiments (such as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
}
}
\examples{
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)

# Generate dose-response plots for geninvitro, with DNA STRAND BREAKS as
# the endpoint and concentrations measured in "ug/cm2" (plot is generated for
# each study provider, with different colours represent different
# experiments):
#
\donttest{nmplot.ncat(data.nm=invitrodata, data.control=controldata,
            id="experimentID", nano="name", response="value",
            dose="concentration", end="endpoint", end.cat="DNA STRAND BREAKS",
            unit="concentration_unit", unit.cat="ug/cm2", cat="studyprovider",
            x.cat="experimentID", type="dose", control.opt="same", nrow=1,
            ncol=1)}

}
