% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChenExp.r
\name{ChenExp}
\alias{ChenExp}
\alias{dchen.exp}
\alias{pchen.exp}
\alias{qchen.exp}
\alias{rchen.exp}
\alias{hchen.exp}
\title{Chen-Exponential Distribution}
\usage{
dchen.exp(x, alpha, beta, lambda, log = FALSE)
pchen.exp(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qchen.exp(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rchen.exp(n, alpha, beta, lambda)
hchen.exp(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dchen.exp}: numeric vector of (log-)densities
  \item \code{pchen.exp}: numeric vector of probabilities
  \item \code{qchen.exp}: numeric vector of quantiles
  \item \code{rchen.exp}: numeric vector of random variates
  \item \code{hchen.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Chen-Exponential distribution.
}
\details{
The Chen-Exponential distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Chen-Exponential distribution has CDF:

\deqn{
F(x;\,\alpha,\beta,\lambda) = \, 1-\exp \left\{\lambda\left[1-\exp 
\left\{\left(e^{\beta x}-1\right)^\alpha\right\} \right] \right\}, \quad x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dchen.exp()} — Density function
  \item \code{pchen.exp()} — Distribution function
  \item \code{qchen.exp()} — Quantile function
  \item \code{rchen.exp()} — Random generation
  \item \code{hchen.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 1, 0.1)
dchen.exp(x, 1.5, 0.8, 2)
pchen.exp(x, 1.5, 0.8, 2)
qchen.exp(0.5, 1.5, 0.8, 2)
rchen.exp(10, 1.5, 0.8, 2)
hchen.exp(x, 1.5, 0.8, 2)
#Data
x <- stress
#ML Estimates    
params = list(alpha=2.5462, beta=0.0537, lambda=87.6028)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pchen.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qchen.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
# Display plot; numerical summary stored in 'out'
out <- gofic(x, params = params, dfun = dchen.exp, 
             pfun = pchen.exp, plot=TRUE)
print.gofic(out)
}
\references{
Chen, Z. (2000). A new two-parameter lifetime distribution with bathtub shape 
or increasing failure rate function. \emph{Statistics & Probability Letters}, 
\bold{49}, 155--161.  

Sapkota, L.P., & Kumar, V. (2023). 
Chen Exponential Distribution with Applications to Engineering Data.
\emph{International Journal of Statistics and Reliability Engineering},
\bold{10(1)}, 33--47. 

Sapkota, L.P., Alsahangiti, A.M., Kumar, V. Gemeay, A.M., Bakr, M.E., Balogun, 
O.S., & Muse, A.H. (2023). Arc-Tangent Exponential Distribution With Applications
to Weather and Chemical Data Under Classical and Bayesian Approach, 
\emph{IEEE Access}, \bold{11}, 115462--115476. \doi{10.1109/ACCESS.2023.3324293}
}
