% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyChen.r
\name{LindleyChen}
\alias{LindleyChen}
\alias{dlindley.chen}
\alias{plindley.chen}
\alias{qlindley.chen}
\alias{rlindley.chen}
\alias{hlindley.chen}
\title{Lindley-Chen Distribution}
\usage{
dlindley.chen(x, alpha, lambda, theta, log = FALSE)
plindley.chen(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.chen(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.chen(n, alpha, lambda, theta)
hlindley.chen(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.chen}: numeric vector of (log-)densities
  \item \code{plindley.chen}: numeric vector of probabilities
  \item \code{qlindley.chen}: numeric vector of quantiles
  \item \code{rlindley.chen}: numeric vector of random variates
  \item \code{hlindley.chen}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley-Chen distribution.
}
\details{
The Lindley-Chen distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Lindley-Chen distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta)
= 1 - \left[ {1 - \lambda \left( {\frac{\theta }{{1 + \theta }}} \right)
\left( {1 - {e^{{x^\alpha }}}} \right)} \right]\;
\exp \left\{ {\lambda \theta \left( {1 - {e^{{x^\alpha }}}} \right)} \right\},
\quad x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dlindley.chen()} — Density function
  \item \code{plindley.chen()} — Distribution function
  \item \code{qlindley.chen()} — Quantile function
  \item \code{rlindley.chen()} — Random generation
  \item \code{hlindley.chen()} — Hazard function
}
}
\examples{
x <- seq(1.0, 3.0, 0.25)
dlindley.chen(x, 0.5, 2, 0.5)
plindley.chen(x, 0.5, 2, 0.5)
qlindley.chen(0.5, 0.5, 2, 0.5)
rlindley.chen(10, 0.5, 2, 0.5)
hlindley.chen(x, 0.5, 2, 0.5)

# Data
x <- fibers65
# ML estimates
params = list(alpha=1.26813, lambda=28.96389, theta=0.00355)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.chen, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.chen, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.chen, pfun=plindley.chen, plot=FALSE)
print.gofic(out)

}
\references{
Bhati, D., Malik, M. A., & Vaman, H. J. (2015). 
Lindley–Exponential distribution: properties and applications. 
\emph{Metron}, \bold{73(3)}, 335--357.
 
Joshi, R. K., & Kumar, V. (2020). 
Lindley-Chen Distribution with Applications. \emph{International Journal 
of Engineering, Science & Mathematics (IJESM)}, \bold{9(10)}, 12--22.
}
