% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyInvExp.r
\name{LindleyInvExp}
\alias{LindleyInvExp}
\alias{dlindley.inv.exp}
\alias{plindley.inv.exp}
\alias{qlindley.inv.exp}
\alias{rlindley.inv.exp}
\alias{hlindley.inv.exp}
\title{Lindley Inverse Exponential Distribution}
\usage{
dlindley.inv.exp(x, lambda, theta, log = FALSE)
plindley.inv.exp(q, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlindley.inv.exp(p, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlindley.inv.exp(n, lambda, theta)
hlindley.inv.exp(x, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlindley.inv.exp}: numeric vector of (log-)densities
  \item \code{plindley.inv.exp}: numeric vector of probabilities
  \item \code{qlindley.inv.exp}: numeric vector of quantiles
  \item \code{rlindley.inv.exp}: numeric vector of random variates
  \item \code{hlindley.inv.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley Inverse Exponential distribution.
}
\details{
The Lindley Inverse Exponential distribution is parameterized by the parameters
\eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Lindley Inverse Exponential distribution has CDF:

\deqn{
F(x; \lambda, \theta) =
1-\left(1-e^{-\lambda / x}\right)^\theta\left\{1-\left(\frac{\theta}{1+\theta}\right)
\ln \left(1-e^{-\lambda / x}\right)\right\} \quad ;\;x > 0.
}

where\eqn{\lambda} and \eqn{\theta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlindley.inv.exp()} — Density function
  \item \code{plindley.inv.exp()} — Distribution function
  \item \code{qlindley.inv.exp()} — Quantile function
  \item \code{rlindley.inv.exp()} — Random generation
  \item \code{hlindley.inv.exp()} — Hazard function
}
}
\examples{
x <- seq(5, 10, 0.5)
dlindley.inv.exp(x, 1.5, 5.0)
plindley.inv.exp(x, 1.5, 5.0)
qlindley.inv.exp(0.5, 1.5, 5.0)
rlindley.inv.exp(10, 1.5, 5.0)
hlindley.inv.exp(x, 1.5, 5.0)

# Data
x <- conductors
# ML estimates
params = list(lambda=33.8992, theta=96.0743)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plindley.inv.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlindley.inv.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlindley.inv.exp, pfun=plindley.inv.exp, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., & Kumar, V. (2020). 
Lindley Inverse Exponential Distribution With Properties and Applications. 
\emph{Bulletin of Mathematics and Statistics Research (BOMSR)}, \bold{8(4)}, 1--13.
}
