% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModGE.r
\name{ModGE}
\alias{ModGE}
\alias{dmod.gen.exp}
\alias{pmod.gen.exp}
\alias{qmod.gen.exp}
\alias{rmod.gen.exp}
\alias{hmod.gen.exp}
\title{Modified Generalized Exponential (MGE) Distribution}
\usage{
dmod.gen.exp(x, alpha, beta, lambda, log = FALSE)
pmod.gen.exp(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.gen.exp(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.gen.exp(n, alpha, beta, lambda)
hmod.gen.exp(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dmod.gen.exp}: numeric vector of (log-)densities
  \item \code{pmod.gen.exp}: numeric vector of probabilities
  \item \code{qmod.gen.exp}: numeric vector of quantiles
  \item \code{rmod.gen.exp}: numeric vector of random variates
  \item \code{hmod.gen.exp}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Modified Generalized Exponential distribution.
}
\details{
The Modified Generalized Exponential distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Modified Generalized Exponential distribution has CDF:

\deqn{
F(x;\alpha,\beta,\lambda)=\left[1-\exp\left\{1-\left(\exp(\beta x)\right)
^{\alpha}\right\}\right]^{\lambda}, \quad x>0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dmod.gen.exp()} — Density function
  \item \code{pmod.gen.exp()} — Distribution function
  \item \code{qmod.gen.exp()} — Quantile function
  \item \code{rmod.gen.exp()} — Random generation
  \item \code{hmod.gen.exp()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dmod.gen.exp(x, 2.0, 0.5, 0.2)
pmod.gen.exp(x, 2.0, 0.5, 0.2)
qmod.gen.exp(0.5, 2.0, 0.5, 0.2)
rmod.gen.exp(10, 2.0, 0.5, 0.2)
hmod.gen.exp(x, 2.0, 0.5, 0.2)

# Data
x <- stress  
# ML estimates
params = list(alpha=3.1502, beta=0.2167, lambda=0.3636)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.gen.exp, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.gen.exp, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.gen.exp, pfun=pmod.gen.exp, plot=FALSE)
print.gofic(out)

}
\references{
Telee, L. B. S., & Kumar, V. (2023). 
Modified Generalized Exponential Distribution.  
\emph{Nepal Journal ofMathematical Sciences}, \bold{4(1)}, 21–32. 
\doi{10.3126/njmathsci.v4i1.53154}

Chaudhary, A. K., Sapkota, L. P., & Kumar, V.(2021). 
Some Properties and Application of Arctan Generalized Exponential Distribution. 
\emph{International Journal of Innovative Research in Science, 
Engineering and Technology (IJIRSET)}, \bold{10(1)},456--468.
}
