% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{NShannon}
\alias{NShannon}
\title{A function to compute Shannon-Wiener diversity normalized index}
\usage{
NShannon(x)
}
\arguments{
\item{x}{an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}
}
\value{
The Shannon-Wiener normalized diversity index value (numeric)
}
\description{
The Shannon-Wiener diversity index is based on 
the notion of entropy and measures population heterogeneity.
}
\examples{
x <- segdata@data[ ,1:2]
NShannon(x) 
}
\references{
Shannon C. E. (1948) \emph{A mathematical theory 
of communication}. Bell System Technical Journal (27)
}
\seealso{
Other multigroup eveness indices: 
\code{\link{HShannon}}, \code{\link{ISimpson}}, 
\code{\link{GiniMulti}}, \code{\link{DMulti}}, \code{\link{HMulti}}, 
\code{\link{CMulti}}

Other multigroup indices: \code{\link{PMulti}}, 
\code{\link{RelDivers}}
}
