% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelper.R
\name{consistent-doc}
\alias{consistent-doc}
\title{Helper for consistent documentation}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object. Run \code{clinicalTables()} to check the
available options.}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}

\item{interval}{Time interval to stratify by. It can either be "years",
"quarters", "months" or "overall".}

\item{sample}{Either an integer or a character string.
\itemize{
\item If an integer (n > 0), the function will first sample \code{n} distinct
\code{person_id}s from the \code{person} table and then subset the input tables to
those subjects.
\item If a character string, it must be the name of a cohort in the \code{cdm}; in
this case, the input tables are subset to subjects (\code{subject_id}) belonging
to that cohort.
\item Use \code{NULL} to disable subsetting (default value).
}}
}
\description{
Helper for consistent documentation
}
\keyword{internal}
