% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.null.R
\name{simulate.null}
\alias{simulate.null}
\title{Simulate from a null distribution}
\usage{
\method{simulate}{null}(x, r)
}
\arguments{
\item{x}{A numeric vector of transcripts.}

\item{r}{A numeric vector of residuals calculated for this transcript.}
}
\value{
A numeric vector of the same length as \code{x}.  Names are not retained.
}
\description{
Simulate transcripts from a Gaussian mixture model fitted to the observed data.
}
\examples{
# Prepare fake data.
set.seed(1234);
x <- rgamma(
    n = 20,
    shape = 2,
    scale = 2
    );
names(x) <- paste('Sample', seq_along(x), sep = '.');
r <- calculate.residuals(
    x = x
    );
r.trimmed <- trim.sample(
    x = r
    );
null <- simulate.null(
    x = x,
    r = r.trimmed
    );
}
