% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-restrictions.R
\name{is_restrictedDAG}
\alias{is_restrictedDAG}
\title{Does a DAG satisfy the restrictions of no active cycle and no
interfering v-structures}
\usage{
is_restrictedDAG(DAG, verbose = 2, check_both = TRUE)
}
\arguments{
\item{DAG}{the DAG object}

\item{verbose}{if \code{verbose} is \code{2}, details are printed.
If \code{verbose} is \code{1}, details are printed only if an active cycle
or an interfering v-structure is found.
If \code{verbose} is \code{0} the function does not print anything and only
returns \code{TRUE} or \code{FALSE}.}

\item{check_both}{if \code{TRUE}, both v-structures and active cycles are
checked anyway. If \code{FALSE}, the function stops early if it already found
any v-structures.}
}
\value{
\code{TRUE} if the PCBN satisfies both restrictions.
\code{FALSE} if at least one of the restrictions is not satisfies.
}
\description{
This functions checks whether the DAG is restricted, i.e. whether it has no
active cycles nor any interfering v-structures.
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

is_restrictedDAG(DAG)  # 1 active cycle

}
\seealso{
\code{\link{DAG_to_restrictedDAG}} for one way of making the DAG
to be restricted if it is not the case.

\code{\link{active_cycles}} to find all active cycles.
\code{\link{has_interfering_vstrucs}} to check only for interfering v-structures.
}
