% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PVBcorrect_functions.R
\name{acc_cca}
\alias{acc_cca}
\title{Complete Case Analysis, CCA}
\usage{
acc_cca(data, test, disease, ci = FALSE, ci_level = 0.95, description = TRUE)
}
\arguments{
\item{data}{A data frame, with at least "Test" and "Disease" variables.}

\item{test}{The "Test" variable name, i.e. the test result. The variable must be in binary; positive = 1, negative = 0 format.}

\item{disease}{The "Disease" variable name, i.e. the true disease status. The variable must be in binary; positive = 1, negative = 0 format.}

\item{ci}{View confidence interval (CI). The default is \code{FALSE}.}

\item{ci_level}{Set the CI width. The default is 0.95 i.e. 95\% CI.}

\item{description}{Print the name of this analysis. The default is \code{TRUE}. This can be turned off for repeated analysis, for example in bootstrapped results.}
}
\value{
A list object containing:
\describe{
  \item{acc_results}{The accuracy results.}
}
}
\description{
Perform Complete Case Analysis, CCA, used for complete data and multiple imputation, MI.
}
\examples{
acc_cca(data = cad_pvb, test = "T", disease = "D")
acc_cca(data = cad_pvb, test = "T", disease = "D", ci = TRUE)
}
