% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{enumerate_parsimony}
\alias{enumerate_parsimony}
\title{Enumerate all the possible regime allocations, given a clustering 
of the tips.}
\usage{
enumerate_parsimony(phylo, clusters = rep(1, length(phylo$tip.label)))
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{clusters}{a vector representing the group of each tip. (Default to only one
group with all the tips.)}
}
\value{
an S3 object of class "\code{enumerate_parsimony}", with:
\describe{
\item{nbrReconstructions}{an object of class "\code{parsimonyCost}", result
of function \code{\link{parsimonyCost}}.}
\item{allocations}{a list of size Nnode + ntaxa. Each entry i of the list
represents the solutions for the subtree starting at node i. It is a list with
nclus entries, each entry being a matrix. A line of the kth matrix for the
ith node is one possible allocation of the shifts, starting with regime k
for node i.}
\item{phylo}{the entry phylogenetic tree}
}
}
\description{
\code{enumerate_parsimony} enumerate all the equivalent allocation of the 
regimes in the tree, a clustering of the tips being given. The number of such
equivalent regimes is given by \code{\link{parsimonyNumber}} (which is faster).
}
\details{
Function \code{\link{extract.enumerate_parsimony}} furnishes the result in a
human readable form (for any subtree).
Function \code{\link{plot.enumerate_parsimony}} plots all the solutions found on
the tree.
}
\examples{
tree <- read.tree(text="(((A,B),C),D);")
plot(tree)
clusters <- c(0, 1, 2, 2)
sols <- enumerate_parsimony(tree, clusters)
plot(sols)

## Extract the parsimonious solutions from the root
extract(sols) # each line is a solution, with states of each node

## Extract the number of solutions from the root
extract(sols, what = "number")
extract(parsimonyNumber(tree, clusters)) # same result, more efficient

## Extract the cost of the solutions from the root
extract(sols, what = "cost")
extract(parsimonyCost(tree, clusters)) # same result, more efficient:

## Extract for the sub-tree below node 7
extract(sols, 7) # NAs: non-existing nodes in the sub-tree

}
\seealso{
\code{\link{extract.enumerate_parsimony}},
\code{\link{plot.enumerate_parsimony}}, \code{\link{parsimonyCost}},
\code{\link{parsimonyNumber}}, \code{\link{partitionsNumber}},
\code{\link{equivalent_shifts}}
}
