% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraint_fn_map.R
\name{fn_map}
\alias{fn_map}
\title{mapping function to transform or penalize weights that violate constraints}
\usage{
fn_map(weights, portfolio, relax = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{weights}{vector of weights}

\item{portfolio}{object of class \code{portfolio}}

\item{relax}{TRUE/FALSE, default FALSE. Enable constraints to be relaxed.}

\item{verbose}{print error messages for debuggin purposes}

\item{\dots}{any other passthru parameters}
}
\value{
\describe{
\item{weights:}{vector of transformed weights meeting constraints.}
\item{min: }{vector of min box constraints that may have been modified if relax=TRUE.}
\item{max: }{vector of max box constraints that may have been modified if relax=TRUE.}
\item{cLO: }{vector of lower bound group constraints that may have been modified if relax=TRUE.}
\item{cUP: }{vector of upper bound group constraints that may have been modified if relax=TRUE.}
}
}
\description{
The purpose of the mapping function is to transform a weights vector
that does not meet all the constraints into a weights vector that
does meet the constraints, if one exists, hopefully with a minimum
of transformation.
}
\details{
The first step is to test for violation of the constraint. If the constraint
is violated, we will apply a transformation such that the weights vector
satisfies the constraints. The following constraint types are tested in
the mapping function: leverage, box, group, and position limit. The 
transformation logic is based on code from the random portfolio sample method.

If relax=TRUE, we will attempt to relax the constraints if a feasible 
portfolio could not be formed with an initial call to \code{rp_transform}. 
We will attempt to relax the constraints up to 5 times. If we do not have a 
feasible portfolio after attempting to relax the constraints, then we will 
default to returning the weights vector that violates the constraints.
}
\author{
Ross Bennett
}
