% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_portfolios.R
\name{random_portfolios}
\alias{random_portfolios}
\alias{random_portfolios_v2}
\title{version 2 generate an arbitary number of constrained random portfolios}
\usage{
random_portfolios(
  portfolio,
  permutations = 100,
  rp_method = "sample",
  eliminate = TRUE,
  ...
)
}
\arguments{
\item{portfolio}{an object of class 'portfolio' specifying the constraints for the optimization, see \code{\link{portfolio.spec}}}

\item{permutations}{integer: number of unique constrained random portfolios to generate}

\item{rp_method}{method to generate random portfolios. Currently "sample", "simplex", or "grid". See Details.}

\item{eliminate}{TRUE/FALSE, eliminate portfolios that do not satisfy constraints}

\item{\dots}{any other passthru parameters}
}
\value{
matrix of random portfolio weights
}
\description{
Generate random portfolios using the 'sample', 'simplex', or 'grid' method. 
See details.
}
\details{
Random portfolios can be generate using one of three methods.
\describe{
  \item{sample: }{The 'sample' method to generate random portfolios is based
  on an idea pioneerd by Pat Burns. This is the most flexible method, but 
  also the slowest, and can generate portfolios to satisfy leverage, box, 
  group, position limit, and leverage exposure constraints.}
  \item{simplex: }{The 'simplex' method to generate random portfolios is 
  based on a paper by W. T. Shaw. The simplex method is useful to generate 
  random portfolios with the full investment constraint, where the sum of the 
  weights is equal to 1, and min box constraints. Values for \code{min_sum} 
  and \code{max_sum} of the leverage constraint will be ignored, the sum of 
  weights will equal 1. All other constraints such as group and position 
  limit constraints will be handled by elimination. If the constraints are 
  very restrictive, this may result in very few feasible portfolios remaining.}
  \item{grid: }{The 'grid' method to generate random portfolios is based on
  the \code{gridSearch} function in package 'NMOF'. The grid search method 
  only satisfies the \code{min} and \code{max} box constraints. The 
  \code{min_sum} and \code{max_sum} leverage constraints will likely be 
  violated and the weights in the random portfolios should be normalized. 
  Normalization may cause the box constraints to be violated and will be 
  penalized in \code{constrained_objective}.}
}

The constraint types checked are leverage, box, group, position limit, and 
leverage exposure. Any
portfolio that does not satisfy all these constraints will be eliminated. This
function is particularly sensitive to \code{min_sum} and \code{max_sum} 
leverage constraints. For the sample method, there should be some 
"wiggle room" between \code{min_sum} and \code{max_sum} in order to generate 
a sufficient number of feasible portfolios. For example, \code{min_sum=0.99} 
and \code{max_sum=1.01} is recommended instead of \code{min_sum=1} 
and \code{max_sum=1}. If \code{min_sum=1} and \code{max_sum=1}, the number of
feasible portfolios may be 1/3 or less depending on the other constraints.
}
\seealso{
\code{\link{portfolio.spec}}, 
\code{\link{objective}}, 
\code{\link{rp_sample}},
\code{\link{rp_simplex}},
\code{\link{rp_grid}}
}
\author{
Peter Carl, Brian G. Peterson, Ross Bennett
}
