% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_fixed_effects_structure}
\alias{get_fixed_effects_structure}
\title{Get the Expected Fixed-Effects Structure}
\usage{
get_fixed_effects_structure(formula, design)
}
\arguments{
\item{formula}{An lme4-style model formula (e.g. \code{outcome ~ predictor1 * predictor2 + (1 | id)}).
Since this function only uses the fixed-effects part of the model, specifying the random effects
is optional here.}

\item{design}{A \code{PowRPriori_design} object created with \code{define_design()}.}
}
\value{
Invisibly returns a named list with placeholders, which can be used
as a template for the \code{fixed_effects} argument in \code{power_sim()}.
}
\description{
Analyzes a model formula and a design object to generate a template for the
\code{fixed_effects} parameter. This is a helper function designed to prevent
typos and ensure all necessary coefficients are specified. By default, this function prints a copy-paste-able code snippet
to the console, where the user only needs to fill in placeholders (\code{...}) for the values.
}
\examples{
design <- define_design(
  id = "subject",
  between = list(group = c("Control", "Treatment")),
  within = list(time = c("pre", "post"))
)
get_fixed_effects_structure(y ~ group * time, design)
}
