% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_data.R
\name{api_data}
\alias{api_data}
\alias{api_data_1}
\alias{api_data_2}
\alias{api_data_12}
\title{PX-Web Data by API}
\usage{
api_data(
  url_or_tableid,
  ...,
  url_type = "ssb",
  use_index = FALSE,
  default_query = c(1, -2, -1),
  return_dataset = NULL,
  make_na_status = TRUE,
  verbose_print = FALSE
)

api_data_1(..., return_dataset = 1)

api_data_2(..., return_dataset = 2)

api_data_12(..., return_dataset = 12)
}
\arguments{
\item{url_or_tableid}{A table id, a PxWebApi v2 URL to data or metadata, or metadata returned by
\code{\link[=meta_data]{meta_data()}} or \code{\link[=meta_frames]{meta_frames()}}.}

\item{...}{Specification of query for each variable. See ‘Details’.}

\item{url_type}{Currently two possibilities: "ssb" (Norwegian) or "ssb_en" (English).}

\item{use_index}{Logical. If TRUE, numeric values are matched against the \code{index} variable in
the metadata, which usually starts at 0. If FALSE (default), numeric values
are interpreted as row numbers in the metadata, using standard R indexing.
Negative values can be used to specify reversed row numbers.}

\item{default_query}{Specification for variables not included in \code{...}.
The default is \code{default_query = c(1, -2, -1)},
which selects the first and the two last codes listed in the metadata.
Use \code{default_query = TRUE}
and omit specifying individual variables to retrieve entire tables.}

\item{return_dataset}{Possible non-NULL values are \code{1}, \code{2} and \code{12}. Then a single data set is returned as a data frame.}

\item{make_na_status}{When TRUE and when dataPackage is \code{"rjstat"} and when missing entries in \code{value},
the function tries to add an additional variable, named \code{NAstatus}, with status codes.
An explanation of these status codes is provided in the note part of the comment attribute,
i.e. what you get with \code{\link[=note]{note()}}. See the bottom example.}

\item{verbose_print}{When TRUE, printing to console}
}
\value{
A data frame, or a list of data frames, depending on the input and
parameters.
}
\description{
This function constructs a PxWebApi v2 data URL using \code{\link[=query_url]{query_url()}}
and retrieves the data using \code{\link[=get_api_data]{get_api_data()}}.
}
\details{
Each variable is specified by using the variable name as an input parameter.

The value can be specified either as a vector or as a list.

\strong{Vector input}

When specified as a vector, this results in a \code{valueCodes} specification.
The vector can be specified in the same way as in a PxWebApi URL.
In addition, the specification method inherited from the legacy
\code{\link[=ApiData]{ApiData()}} function for PxWebApi v1 can be used:
\itemize{
\item \code{TRUE} means all values and is equivalent to \code{"*"}.
\item \code{FALSE} means eliminated, which is equivalent to removing the variable
from the URL. This is meaningful for variables that can be eliminated;
see the lower examples in \code{\link[=meta_frames]{meta_frames()}}.
\item Imaginary values represent \code{top}, e.g. \code{3i} is equivalent to \code{"top(3)"}.
\item Numeric values are interpreted as row numbers (negative values allowed)
or as indices; see the parameter description of \code{use_index}.
\item Codes can be specified directly, including the use of wildcards such as
\code{"*"} and \code{"??"}. Labels may also be used as an alternative to codes.
}

\strong{List input}

When the input is a named list, the URL is constructed directly from the
names and elements of the list (see examples).
It is also possible to omit the name of a list element. In this case, the
element results in a \code{valueCodes} specification and is processed in the same
way as vector input.
}
\examples{

obj <- api_data(14162, Region = FALSE, InnKvartering1 = FALSE, Landkoder2 = FALSE, 
                ContentsCode = TRUE, Tid = 3i, url_type = "ssb_en")
          
obj[[1]]    # The label version of the dataset, as returned by api_data_1()
obj[[2]]    # The code version of the dataset, as returned by api_data_2()
names(obj)
info(obj)   # Similar to comment(); see also note() below

 # same as above 
 # api_data("https://data.ssb.no/api/pxwebapi/v2/tables/14162/data?lang=en", 
 #           default_query = FALSE, ContentsCode = "*", Tid = "top(3)")
 
 # also same as above 
 # api_data(14162, url_type = "ssb_en", default_query = FALSE,
 #          ContentsCode = list(valueCodes = "*"), 
 #          Tid = list(valueCodes = "top(3)"))

 api_data_1("https://data.ssb.no/api/pxwebapi/v2/tables/09546/data?lang=en",
            Region = FALSE, SkoleSTR = "07", GrSkolOrgForm = "4", 
            EierforhSkole = 1:2, ContentsCode = TRUE, Tid = "202?") 
            
 api_data_2("https://data.ssb.no/api/pxwebapi/v2/tables/07459/data?lang=en",
            Region = list(codelist = "agg_KommSummer", 
                          valueCodes = c("K-3101", "K-3103"), 
                          outputValues = "aggregated"),
            Kjonn = TRUE,
            Alder = list(codelist = "agg_TodeltGrupperingB", 
                         valueCodes = c("H17", "H18"),
                         outputValues = "aggregated"),
            ContentsCode = 1,
            Tid = 2i)           
            
 # codes and labels can be mixed            
 api_data_12(4861, 
             Region = c("Sarpsborg", "3103", "402?"), 
             ContentsCode = "Bosatte", 
             Tid = c(1, -1), 
             url_type = "ssb_en") 
             
 
 # A Statistics Sweden example             
 api_data_12("https://statistikdatabasen.scb.se/api/v2/tables/TAB4537/data?lang=en", 
             Region = "??", 
             Kon = FALSE)                      

 
 # Use default_query = TRUE to retrieve entire tables
 out <- api_data_2("https://data.ssb.no/api/pxwebapi/v2/tables/10172/data?lang=en", 
                            default_query = TRUE)
 out[14:22, ]  # 9 rows printed      

 
 # Use note() for explanation of status codes (see api_data() parameter makeNAstatus)                       
 note(out)
 
 # info() and note() return parts of the comment attribute
 info(out)
 comment(out)

}
