% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namesCompare.R
\name{namesCompare}
\alias{namesCompare}
\title{Checking species names for misspelling and synonyms}
\usage{
namesCompare(vec1,vec2,proportion=0.15,
  focus=c("genus","subspecies","epithet","misspelling"))
}
\arguments{
\item{vec1, vec2}{a vector of species names. Genus names only are also
allowed. Generic name and specific epithet must be separated by '_'. Note
that \code{vec2} is used as the reference. Incomplete or suspicious names
are better placed in \code{vec1} (see example below).}

\item{proportion}{the maximum proportion of different characters between any
\code{vec1-vec2} names pair to consider it a possible misspelling.}

\item{focus}{one or more of \code{"genus"}, \code{"subspecies"},
\code{"epithet"}, \code{"misspelling"}. See Values for details.}
}
\value{
The function returns a \code{list} including (according to \code{focus}):

\strong{$genus} if \code{vec1} includes genera names which miss
  specific epithet, this object lists all the species in \code{vec2}
  belonging to each of the genera.

\strong{$subspecies} if \code{vec1} includes subspecies (i.e. two
  epithets after genus name), this object lists species in \code{vec2}
  possibly corresponding to each of the subspecies.

\strong{$epithet} lists species with matching epithets as possible
  synonyms.

\strong{$misspelling} lists possible misspelled names. For each
  proposed mismatched names pair the proportion of characters in the
  \code{vec1} differing from the string in \code{vec2} is returned.
}
\description{
The function cross-references two vectors of species names
  checking for possible synonyms, misspelled names, and genus-species or
  species-subspecies correspondence.
}
\examples{
\dontrun{
names(DataFelids$statefel)->nams.fel
nams.fel[c(19,12,37,80,43)]<-c("Puma_yagouaroundi","Felis_manul","Catopuma",
                           "Pseudaelurus","Panthera_zdansky")
nams<-nams.fel[-81]

namesCompare(nams,names(DataFelids$statefel))->nc1
namesCompare(names(DataFelids$statefel),nams)->nc2
}
}
\author{
Silvia Castiglione, Carmela Serio, Antonella Esposito
}
