% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rajive_helpfunctions.R
\name{decomposition_heatmaps_robustH}
\alias{decomposition_heatmaps_robustH}
\title{Decomposition Heatmaps}
\usage{
decomposition_heatmaps_robustH(blocks, jive_results_robust)
}
\arguments{
\item{blocks}{List. The initial data blocks.}

\item{jive_results_robust}{List. The RaJIVE decomposition.}
}
\value{
The heatmap of the decomposition
}
\description{
Visualization of the RaJIVE decomposition, it shows heatmaps of the decomposition obtained by RaJIVE
}
\examples{
\donttest{
n <- 10
pks <- c(20, 10)
Y <- ajive.data.sim(K =2, rankJ = 2, rankA = c(7, 4), n = n,
                 pks = pks, dist.type = 1)
initial_signal_ranks <-  c(7, 4)
data.ajive <- list((Y$sim_data[[1]]), (Y$sim_data[[2]]))
ajive.results.robust <- Rajive(data.ajive, initial_signal_ranks)
decomposition_heatmaps_robustH(data.ajive, ajive.results.robust)
}
}
