% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{extract_array_element}
\alias{extract_array_element}
\title{Extract Array Elements Safely}
\usage{
extract_array_element(array_col, index = NULL, default = NA)
}
\arguments{
\item{array_col}{A list column from DuckDB array data}

\item{index}{Numeric index (1-based). If NULL, returns full list}

\item{default}{Default value if index is out of bounds}
}
\value{
The array element at the specified index, or full array if index is NULL
}
\description{
Helper function to safely extract elements from DuckDB arrays
(returned as R lists) with proper error handling.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
bcf_path <- system.file("extdata", "vcf_file.bcf", package = "Rduckhts")
rduckhts_bcf(con, "variants", bcf_path, overwrite = TRUE)
data <- dbGetQuery(con, "SELECT ALT FROM variants LIMIT 5")
first_alt <- extract_array_element(data$ALT, 1)
all_alts <- extract_array_element(data$ALT)
dbDisconnect(con, shutdown = TRUE)

}
