% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runapp_ilostat.R
\name{runapp_ilostat}
\alias{runapp_ilostat}
\title{Play with ILOSTAT data apps}
\usage{
runapp_ilostat(name = "dataexplorer")
}
\arguments{
\item{name}{`chr` The name of the application to open.

  Available applications:
  \itemize{
    \item{"dataexplorer"}: Quickly find, filter, pivot, and download ILOSTAT data.
    \item{"microquery"}: Explore data availability and create custom queries from the ILO Harmonized Microdata Collection. Users can select variables, filters, and indicators to generate tailored datasets.
    \item{"regionalaggregate"}: Generate custom regional estimates by defining or selecting country groupings. The app automatically aggregates country-level modelled data for selected indicators.
  }}
}
\description{
Open various data exploration and analysis applications hosted by the ILO.
}
\examples{
\dontrun{

  runapp_ilostat(name = "dataexplorer")

  # You can also run other apps like:
  runapp_ilostat(name = "microquery")
  runapp_ilostat(name = "regionalaggregate")


}
}
\references{
See citation("Rilostat")
}
\seealso{
Additional documentation for microdata:
\itemize{
  \item{\href{https://www.ilo.org/publications/ilostat-microdata-processing-quick-guide-principles-and-methods-underlying}{Quick guide on microdata processing}}
  \item{\href{https://rplumber.ilo.org/files/website/Ad_Hoc_Micro_ISIC_ISCO_Adjustment_procedure.pdf}{Adjustment procedure for ISCO- and ISIC-based estimates}}
  \item{\href{https://rplumber.ilo.org/files/website/Ad_Hoc_Micro_ISIC_ISCO_Global_Regional_Estimates.pdf}{Methodology for ad hoc global and regional estimates}}
  \item{\href{https://rplumber.ilo.org/files/website/Ad_Hoc_Micro_Query_Citation.pdf}{Citations}}
}
}
\author{
David Bescond \email{bescond@ilo.org}
}
