% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOverviewInput.R
\name{getOverviewInput}
\alias{getOverviewInput}
\title{Get an overview of the given root scans}
\usage{
getOverviewInput(data_dir, data_dirs = NULL, naming_conv = "standard")
}
\arguments{
\item{data_dir}{(Optional, default = NULL) String specifying the name
(full path) of the directory containing all root scan directories of
interest.}

\item{data_dirs}{(Optional, default = NULL) Character vector specifying all
of the individual root scan directories of interest. This is only used if
\code{data_dir} is set to NULL.}

\item{naming_conv}{A string specifying the naming convention, i.e., what
information is provided within the names of the root scans. The file format
can be png, tiff, jpg, or jpeg (upper or lowercase).
Available are: \cr
\itemize{
\item "standard" (default): This is a commonly used naming convention and has the
following structure: \cr
project_tube_depth_date_ID_session_operator \cr
Example: \cr
Testproject_T007_L004_12.12.2025_123394_016_Testoperator.jpg \cr
Explanation of the abbreviations: \cr
-- project: Project name ('unlimited' letters or digits)\cr
-- tube: ID of the minirhizotron ("T"+3 digits) \cr
-- depth: ID of the depth-level/window ("L"+3 digits) \cr
-- date: Date of the scanning (format day.month.year,
2 digits +"."+ 2 digits +"."+ 2 or 4 digits) \cr
-- ID: ID of the scan (6 digits) or timecode 14:23:10 -> 142310 \cr
-- session: ID of the scan session (3 digits). \cr
-- operator: ID of the person that scanned the root ('unlimited'
letters or digits)
}}
}
\value{
\code{getOverviewInput} A data frame containing the information
about the various root scan directories (see also
\code{getDepthLvlInfo()} for further explanations).
}
\description{
\code{getOverviewInput} - This function filters a set of root scan
directories by checking if they comply with the given naming convention and
then returns overview data about these directories.
}
\examples{
getOverviewInput(data_dir = NULL, naming_conv = "standard")
}
