% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fake_data}
\alias{fake_data}
\title{Fake occurrence data for testing coordinate validation functions}
\format{
A data frame with the same structure as \code{all_occ}, containing
occurrence records with intentionally manipulated coordinates.
An additional column \code{data_source = "fake_data"} identifies these records.
}
\usage{
fake_data
}
\description{
\code{fake_data} is a synthetic dataset created for testing functions that validate
and correct country- or state-level geographic coordinates.

Controlled coordinate errors were introduced (e.g., inverted signs,
swapped values, combinations of swaps and inversions) to simulate common
georeferencing mistakes.

This dataset is intended for automated testing of functions such as
\code{check_countries()} and \code{check_states()}.
}
\details{
The coordinate errors include:

\itemize{
\item \strong{Inverted longitude}: multiplying longitude by -1.
\item \strong{Inverted latitude}: multiplying latitude by -1.
\item \strong{Both coordinates inverted}.
\item \strong{Swapped coordinates}: (\code{lon}, \code{lat}) → (\code{lat}, \code{lon}).
\item \strong{Swapped + inverted} in four combinations:
\itemize{
\item swapped only,
\item swapped + inverted longitude,
\item swapped + inverted latitude,
\item swapped + both inverted.
}
}
}
\examples{
data(fake_data)
}
\keyword{datasets}
