% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_error_handling.R
\name{s_safely}
\alias{s_safely}
\title{Safe Safely - Wrap Function to Capture Errors}
\usage{
s_safely(.f, otherwise = NULL, quiet = TRUE)
}
\arguments{
\item{.f}{A function to wrap for safe execution.}

\item{otherwise}{Default return value when an error occurs.}

\item{quiet}{Logical. Hide errors from console if TRUE.}
}
\value{
A function that returns a list with 'result' and 'error' components.
}
\description{
Drop-in replacement for purrr::safely that captures errors and returns
them in a structured format.
}
\examples{
safe_log <- s_safely(log)
safe_log(10) # Returns list(result = 2.30, error = NULL)
safe_log("a") # Returns list(result = NULL, error = <error>)

}
