% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_helpers.R
\name{plot_compare_freq}
\alias{plot_compare_freq}
\title{Side-by-side selection-frequency heatmap}
\usage{
plot_compare_freq(freq_tab)
}
\arguments{
\item{freq_tab}{Data frame as returned by \code{\link[=compare_selectors_bootstrap]{compare_selectors_bootstrap()}}.}
}
\value{
A \code{ggplot} object when \code{ggplot2} is available; otherwise draws a base R image.
}
\description{
Visual comparison of bootstrap selection frequencies by selector. Requires \code{ggplot2}.
}
\examples{
freq_tab <- data.frame(
  selector = rep(c("AIC", "BIC"), each = 3),
  variable = rep(paste0("x", 1:3), times = 2),
  freq = c(0.85, 0.2, 0.45, 0.75, 0.35, 0.3)
)
plot_compare_freq(freq_tab)
}
