% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVbound.R
\name{SVbound}
\alias{SVbound}
\title{Smith and VanderWeele bound}
\usage{
SVbound(
  whichEst,
  sens = NULL,
  pY1_T1_S1,
  pY1_T0_S1,
  pT1_S1 = NULL,
  pT0_S1 = NULL,
  RR_UY_T1 = NULL,
  RR_UY_T0 = NULL,
  RR_SU_11 = NULL,
  RR_SU_00 = NULL,
  RR_SU_10 = NULL,
  RR_SU_01 = NULL,
  RR_UY_S1 = NULL,
  RR_TU_1 = NULL,
  RR_TU_0 = NULL
)
}
\arguments{
\item{whichEst}{Input string. Defining the causal estimand of interest.
Available options are as follows. (1) Risk ratio in the total
population: \code{"RR_tot"}, (2) Risk difference in the total population:
\code{"RD_tot"}, (3) Risk ratio in the subpopulation: \code{"RR_sub"}, (4) Risk
difference in the subpopulation: \code{"RD_sub"}.}

\item{sens}{Possible method to input sensitivity parameters. \code{sens} can
be the output from sensitivityparametersM(), a data.frame with columns
'parameter' and 'value', or a name list with correct names (e.g.
\code{"RR_UY_T1"},  \code{"RR_UY_T0"}, etc.). If not supplied, parameters can be
entered manually as specified below.}

\item{pY1_T1_S1}{Input value. The probability P(Y=1|T=1,I_S=1). Must be
between 0 and 1.}

\item{pY1_T0_S1}{Input value. The probability P(Y=1|T=0,I_S=1). Must be
between 0 and 1.}

\item{pT1_S1}{Input value. The probability P(T=1|I_S=1). Must be
between 0 and 1. Only used for the alternative SV bound for the risk
difference in the subpopulation. If a value is given to \code{pT1_S1} and
\code{pT0_S1}, the alternative bound is used. If they are set to \code{NULL},
the original SV bound will be used.}

\item{pT0_S1}{Input value. The probability P(T=0|I_S=1). Must be
between 0 and 1. Only used for the alternative SV bound for the risk
difference in the subpopulation. If a value is given to \code{pT1_S1} and
\code{pT0_S1}, the alternative bound is used. If they are set to \code{NULL},
the original SV bound will be used.}

\item{RR_UY_T1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|T=1. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_UY_T0}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|T=0. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_11}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|11. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_00}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|00. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_10}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|10. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_01}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|01. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_UY_S1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|S=1. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}

\item{RR_TU_1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_TU|1. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}

\item{RR_TU_0}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_TU|0. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}
}
\value{
A list containing the Smith and VanderWeele lower and upper bounds.
}
\description{
\code{SVbound()} returns a list with the SV bound. All sensitivity parameters for
the population of interest must be set to numbers, and the rest can be left
as \code{NULL}. The sensitivity parameters can be inserted directly or as output
from \code{sensitivityparametersM()}.
}
\examples{
# Example specifying the sensitivity parameters manually. Risk ratio in
# the total population.
SVbound(whichEst = "RR_tot", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 RR_UY_T1 = 2, RR_UY_T0 = 2, RR_SU_11 = 1.7, RR_SU_00 = 1.5,
 RR_SU_10 = 2.1, RR_SU_01 = 2.3)
 
# Example specifying the sensitivity parameters manually. Risk difference in
# the total population.
SVbound(whichEst = "RD_tot", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 RR_UY_T1 = 2, RR_UY_T0 = 2, RR_SU_11 = 1.7, RR_SU_00 = 1.5,
 RR_SU_10 = 2.1, RR_SU_01 = 2.3)

# Example specifying the sensitivity parameters manually. Risk ratio in
# the subpopulation. 
SVbound(whichEst = "RR_sub", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 RR_UY_S1 = 2.71, RR_TU_1 = 1.91, RR_TU_0 = 2.33)

# Example specifying the sensitivity parameters manually. Risk difference in
# the subpopulation.
SVbound(whichEst = "RD_sub", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 RR_UY_S1 = 2.71, RR_TU_1 = 1.91, RR_TU_0 = 2.33)
 
# Example specifying the sensitivity parameters manually. 
# Risk difference in the subpopulation with the alternative bound.
SVbound(whichEst = "RD_sub", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01, pT1_S1 = 0.6,
pT0_S1 = 0.3, RR_UY_S1 = 2.71, RR_TU_1 = 1.91, RR_TU_0 = 2.33)

# Example specifying the sensitivity parameters from sensitivityparametersM().
# Risk ratio in the subpopulation. DGP from the zika example.
V = matrix(c(1, 0, 0.85, 0.15), ncol = 2)
U = matrix(c(1, 0, 0.5, 0.5), ncol = 2)
Tr = c(-6.2, 1.75)
Y = c(-5.2, 5.0, -1.0)
S = matrix(c(1.2, 2.2, 0.0, 0.5, 2.0, -2.75, -4.0, 0.0), ncol = 4)
probT1 = 0.286
probT0 = 0.004
senspar = sensitivityparametersM(whichEst = "RR_sub", whichBound = "SV", Vval = V,
 Uval = U, Tcoef = Tr, Ycoef = Y, Scoef = S, Mmodel = "L",
 pY1_T1_S1 = probT1, pY1_T0_S1 = probT0)
 
SVbound(whichEst = "RR_sub", sens = senspar, pY1_T1_S1 = probT1, pY1_T0_S1 = probT0)

}
\references{
Smith, Louisa H., and Tyler J. VanderWeele. "Bounding bias due
to selection." Epidemiology (Cambridge, Mass.) 30.4 (2019): 509.

Zetterstrom S, Sjölander A, Waernbaum I. "Investigations of sharp bounds
for causal effects under selection bias." Statistical Methods in Medical
Research (2025).

Zetterstrom, Stina and Waernbaum, Ingeborg. "Selection bias and multiple
inclusion criteria in observational studies" Epidemiologic Methods 11, no.
1 (2022): 20220108.
}
