% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stDPP.R
\name{plot_stDPP}
\alias{plot_stDPP}
\title{Plot spatio-temporal determinantal point process (DPP) realizations}
\usage{
plot_stDPP(data, type = c("3D", "space", "time"), alpha_s, alpha_t)
}
\arguments{
\item{data}{A spatio-temporal point pattern object suitable for
\code{plot_stpp()}, typically from the \pkg{stpp} or related packages.}

\item{type}{Character string specifying the type of plot to produce.
This is passed directly to \code{plot_stpp()}. Typical values are \code{"3D"}, \code{"space"}, and \code{"time"}.}

\item{alpha_s}{Numeric scalar (> 0). Spatial interaction parameter of the DPP model.}

\item{alpha_t}{Numeric scalar (> 0). Temporal interaction parameter of the DPP model.}
}
\value{
No return value. The function is called for its side effect of
producing a diagnostic plot.
}
\description{
Produces diagnostic plots for spatio-temporal determinantal point process
(DPP) simulations or fitted models. The function formats the plot title
based on the spatial and temporal interaction parameters \eqn{\alpha_s} and
\eqn{\alpha_t}, automatically displaying either the parameters themselves or
their reciprocals when greater than 1.
}
\details{
If \eqn{\alpha_s > 1} and \eqn{\alpha_t > 1}, the title displays
\eqn{\alpha_s^{-1}} and \eqn{\alpha_t^{-1}}, which correspond to interaction
ranges. Otherwise, the parameters are shown directly.

The function then calls \code{plot.ST.pp()} to produce the actual plot.
}
\examples{

# Simulate a stationary separable Matérn ST-DPP
sim <- rstDPP(
  mode     = "stationary",
  model    = "S",
  spectral = "matern",
  alpha_s  = 10,
  alpha_t  = 4.7,
  nu       = 2,
  eps      = 1,
  lambda_max = 70,
  grid_size  = 1.5
)
 plot_stDPP(sim, type = "3D",  alpha_s = 10, alpha_t = 4.7)

}
