% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_ST_LGCP.R
\name{rstLGCPP}
\alias{rstLGCPP}
\title{Simulate a spatio-temporal Log-Gaussian Cox process (LGCP)}
\usage{
rstLGCPP(
  xlim = NULL,
  ylim = NULL,
  tlim = NULL,
  grid = c(15, 15, 10),
  mu = NULL,
  Lambda = NULL,
  Lmax = NULL,
  par1 = c(1, 0.05),
  par2 = c(1, 0.06),
  sigmas = c(0.5, 0.5, 1),
  mu_par = c(1.2, 0.25, 5)
)
}
\arguments{
\item{xlim, ylim, tlim}{Numeric vectors of length 2 specifying the spatial and temporal domains.}

\item{grid}{Integer vector of length 3 specifying the number of grid cells in x, y, and t.}

\item{mu}{Optional. A function of (x, y, t, par) defining a deterministic trend. Default is nonlinear.}

\item{Lambda}{Optional. A user-supplied 3D intensity array or function. If \code{NULL}, it's generated from the latent Gaussian field.}

\item{Lmax}{Optional. Maximum intensity used for thinning. Can be numeric or a function. If \code{NULL}, it's computed automatically.}

\item{par1, par2}{Parameters for temporal and spatial exponential covariance models, respectively.}

\item{sigmas}{Weights for combining spatial, temporal, and spatio-temporal components of the latent Gaussian field.}

\item{mu_par}{Parameters passed to the default trend function \code{mu()} if not user-supplied.}
}
\value{
A list with:
\describe{
\item{st.lgcp}{A data frame of simulated spatio-temporal points.}
\item{RF}{The latent Gaussian field output from \code{\link{Gauss.st.F}}.}
}
}
\description{
Generates a realization of a spatio-temporal LGCP over a user-defined domain. The process is simulated
using a log-Gaussian random field combined with a deterministic trend function, and points are generated
by thinning a homogeneous Poisson process.
}
\examples{

out <- rstLGCPP(xlim = c(0,1),
                ylim = c(0,1),
                tlim = c(0,1),
                grid = c(15,15,10))
plot_stlgcp(data = out)
plot_stpp(data = out$st.lgcp, type = "3D")

}
