% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambert.R
\name{lambertW0}
\alias{lambertW0}
\title{Lambert W0 function}
\usage{
lambertW0(x)
}
\arguments{
\item{x}{numeric vector of values.}
}
\description{
W0(x) is the principal branch of the solution of the function
defined by \eqn{We^W = x}{W * exp(W)} for \eqn{x >= -1/e}. The
value is calculated using GNU Scientific Library (GSL).
}
\examples{
## Should equal 1, as 1 * exp(1) = e.
lambertW0(exp(1))

## Should equal 0, as 0 * exp(0) = 0.
lambertW0(0)

## Should equal -1.
lambertW0(-exp(-1))
}
\references{
GNU Scientific Library <https://www.gnu.org/software/gsl/>
}
