% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_exp_table}
\alias{get_exp_table}
\title{Retrieve the experiment table for the SkeletalVis database}
\usage{
get_exp_table(skeletalvis)
}
\arguments{
\item{skeletalvis}{The path to the skeletalvis data folder.}
}
\value{
A dataframe containing the experiment information
}
\description{
Retrieves the experiment table file containing experiment accessions and descriptions from the skeletalvis database.
}
\examples{
# Get the path to the directory with the accessions.txt file
skeletalvis_path <- load_skeletalvis(demo=TRUE)

# Retrieve the metadata
exptable <- get_exp_table(skeletalvis_path)

# View the metadata
head(exptable)
}
