% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSroundingLoop.R
\name{PLSroundingLoop}
\alias{PLSroundingLoop}
\title{PLSrounding on portions of data at a time}
\usage{
PLSroundingLoop(
  data,
  loopId,
  ...,
  zeroCandidates = FALSE,
  forceInner = FALSE,
  preRounded = NULL,
  plsWeights = NULL,
  printInc = TRUE,
  preDifference = TRUE,
  preOutput = NULL,
  rndSeed = 123,
  action_unused_dots = "warn"
)
}
\arguments{
\item{data}{Input data as a data frame (inner cells)}

\item{loopId}{Variable holding id for loops}

\item{...}{\code{PLSrounding} parameters}

\item{zeroCandidates}{\code{PLSrounding} parameter (see details)}

\item{forceInner}{\code{PLSrounding} parameter (see details)}

\item{preRounded}{\code{PLSrounding} parameter (see details)}

\item{plsWeights}{\code{PLSrounding} parameter (see details)}

\item{printInc}{Printing iteration information to console when TRUE}

\item{preDifference}{When TRUE, the \code{preDifference} parameter to \code{PLSrounding} is used. Each time with the differences obtained so far.}

\item{preOutput}{preOutput The function can continue from output from a previous run}

\item{rndSeed}{If non-NULL, a random generator seed to be set locally at the beginning of \code{PLSroundingLoop} without affecting the random value stream in R.
Within \code{PLSroundingLoop}, \code{PLSrounding} is called with \code{rndSeed = NULL}.}

\item{action_unused_dots}{\code{PLSrounding} parameter.}
}
\value{
As output from \code{\link{PLSrounding}}
}
\description{
The \code{\link{PLSrounding}} runs are coordinated by using preliminary differences as input for the next run (parameter \code{preDifference})
}
\details{
Note that in this function \code{zeroCandidates}, \code{forceInner}, \code{preRounded} and \code{plsWeights} cannot be supplied as vectors.
They may be specified as functions or as variables in the input data.
}
\examples{
mf2 <- ~region + fylke * hovedint
z2 <- SmallCountData("z2")
a <- PLSroundingLoop(z2, loopId = "kostragr", freqVar = "ant", formula = mf2)
a
}
