% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsedc_gap.r
\name{sparsedc_gap}
\alias{sparsedc_gap}
\title{Gap Statistic Calculator}
\usage{
sparsedc_gap(pdat1, pdat2, min_clus, max_clus, nboots = 200, nitter = 20,
  nstarts = 10, l1_boot = 50, l2_boot = 50)
}
\arguments{
\item{pdat1}{The centered data from condition 1, columns should be
samples (cells) and rows should be features (genes).}

\item{pdat2}{The centered data from condition 2, columns should be
samples (cells) and rows should be features (genes). The number of genes
should be the same as \code{pdat1}.
as in pdat1.}

\item{min_clus}{The minimum number of clusters to try, minimum value is 2.}

\item{max_clus}{The maximum number of clusters to try.}

\item{nboots}{The number of bootstrap repetitions to use, default = 200.}

\item{nitter}{The max number of iterations for each of the start values, the
default value is 20.}

\item{nstarts}{The number of start values to use for SparseDC. The default
value is 10.}

\item{l1_boot}{The number of bootstrap repetitions used for estimating
lambda 1.}

\item{l2_boot}{The number of bootstrap repetitions used for estimating
lambda 2.}
}
\value{
A list containing the optimal number of clusters, as well as gap
statistics and the calculated standard error for each number of clusters.
}
\description{
This function calculates the gap statistic for SparseDC. For use
when the number of clusters in the data is unknown. We recommend
using alternate methods to infer the number of clusters in the
data.
}
\examples{
# load a small dataset
data_test <- data_biase[1:50,]
# Split data into conditions 1 and 2
data_1 <- data_test[ , which(condition_biase == "A")]
data_2 <- data_test[ , which(condition_biase == "B")]
# Preprocess data (log transform and center)
pre_data <- pre_proc_data(data_1, data_2, norm = FALSE, log = TRUE,
center = TRUE)
# Run with one bootstrap sample for example
gap_stat <- sparsedc_gap(pre_data[[1]], pre_data[[2]],
 min_clus <- 2, max_clus <- 3, nboots <- 2)


}
