% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.taf.R
\name{read.taf}
\alias{read.taf}
\title{Read TAF Table}
\usage{
read.taf(file, check.names = FALSE, stringsAsFactors = FALSE,
  fileEncoding = "UTF-8", ...)
}
\arguments{
\item{file}{a filename.}

\item{check.names}{whether to enforce regular column names, e.g. convert
column name \code{"3"} to \code{"X3"}.}

\item{stringsAsFactors}{whether to import strings as factors.}

\item{fileEncoding}{character encoding of input file.}

\item{...}{passed to \code{read.csv}.}
}
\value{
A data frame, or a list of data frames if \code{file} is a directory or a
vector of filenames.
}
\description{
Read from a CSV file into a data frame.
}
\details{
Alternatively, \code{file} can be a directory or a vector of filenames, to
read many tables in one call.
}
\note{
This function gives a warning when column names are missing or duplicated. It
also gives a warning if the data frame has zero rows.
}
\examples{
\dontrun{
write.taf(catage.taf, "catage.csv")
catage <- read.taf("catage.csv")

write.taf(catage)
file.remove("catage.csv")
}

}
\seealso{
\code{\link{read.csv}} is the underlying function used to read a table from a
file.

\code{\link{write.taf}} writes a data frame to a CSV file.

\code{\link{TAF-package}} gives an overview of the package.
}
