ind_test_boot <- function(X, n.boot = 200, score = "Identity", weight = "Gauss", ncores = NULL, iseed = NULL) {
  # Match arguments and allow partial matching
  score <- match.arg(score, c("Identity", "Ranks", "VDW"))
  weight <- match.arg(weight, c("Gauss", "Laplace"))
  
  # Construct a key to use in the switch statement
  func_key <- paste(score, weight, sep = "_")
  
  # Use switch to select the appropriate function
  result <- switch(func_key,
                   "Identity_Gauss" = ICAtestGauss_S_par(X, n.boot, ncores, iseed),
                   "Identity_Laplace" = ICAtestLap_S_par(X, n.boot, ncores, iseed),
                   "Ranks_Laplace" = ICAtestRankLap_S_par(X, n.boot, ncores, iseed),
                   "Ranks_Gauss" = ICAtestRankGauss_S_par(X, n.boot, ncores, iseed),
                   "VDW_Gauss" = ICAtestRankvdW_S_par(X, n.boot, ncores, iseed)
  )
  
  # Append additional information to the result
  result$score <- score
  result$weight <- weight
  
  return(result)
}
