% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advanced_search.R
\name{ACLFilter}
\alias{ACLFilter}
\title{ACL Filter}
\description{
Access Control List filter for security-aware search
}
\examples{
\dontrun{
acl_filter <- ACLFilter$new()
filtered <- acl_filter$filter(
  documents = results,
  user_principals = c("user:alice", "group:engineering")
)
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{acl_field}}{Metadata field containing ACLs}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ACLFilter-new}{\code{ACLFilter$new()}}
\item \href{#method-ACLFilter-filter}{\code{ACLFilter$filter()}}
\item \href{#method-ACLFilter-add_acl}{\code{ACLFilter$add_acl()}}
\item \href{#method-ACLFilter-create_filter_condition}{\code{ACLFilter$create_filter_condition()}}
\item \href{#method-ACLFilter-clone}{\code{ACLFilter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ACLFilter-new"></a>}}
\if{latex}{\out{\hypertarget{method-ACLFilter-new}{}}}
\subsection{Method \code{new()}}{
Create a new ACLFilter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ACLFilter$new(acl_field = "_acl")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{acl_field}}{Field name for ACLs (default: "_acl")}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ACLFilter-filter"></a>}}
\if{latex}{\out{\hypertarget{method-ACLFilter-filter}{}}}
\subsection{Method \code{filter()}}{
Filter documents based on user's ACL principals
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ACLFilter$filter(documents, user_principals, default_allow = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{documents}}{List of documents with metadata}

\item{\code{user_principals}}{Character vector or list of ACLPrincipal}

\item{\code{default_allow}}{Allow if no ACL defined (default: FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Filtered documents
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ACLFilter-add_acl"></a>}}
\if{latex}{\out{\hypertarget{method-ACLFilter-add_acl}{}}}
\subsection{Method \code{add_acl()}}{
Add ACL to document metadata
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ACLFilter$add_acl(metadata, principals)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadata}}{Document metadata}

\item{\code{principals}}{Character vector of principal strings}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Updated metadata
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ACLFilter-create_filter_condition"></a>}}
\if{latex}{\out{\hypertarget{method-ACLFilter-create_filter_condition}{}}}
\subsection{Method \code{create_filter_condition()}}{
Create ACL filter condition for query
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ACLFilter$create_filter_condition(user_principals)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_principals}}{Character vector of principals}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Filter condition list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ACLFilter-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ACLFilter-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ACLFilter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
