% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphrag.R
\name{GraphRAGConfig}
\alias{GraphRAGConfig}
\title{GraphRAG Configuration}
\description{
Configuration for VectrixDB's GraphRAG implementation
}
\examples{
\dontrun{
config <- GraphRAGConfig$new(enabled = TRUE)
db <- Vectrix$new("knowledge_base", graphrag_config = config)
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{enabled}}{Whether GraphRAG is enabled}

\item{\code{chunk_size}}{Target tokens per chunk}

\item{\code{chunk_overlap}}{Overlapping tokens}

\item{\code{chunk_by_sentence}}{Preserve sentence boundaries}

\item{\code{extractor}}{Extraction method}

\item{\code{nlp_model}}{NLP model name}

\item{\code{llm_provider}}{LLM provider}

\item{\code{llm_model}}{Model name}

\item{\code{llm_api_key}}{API key}

\item{\code{llm_endpoint}}{Custom endpoint}

\item{\code{llm_temperature}}{Temperature}

\item{\code{llm_max_tokens}}{Max tokens}

\item{\code{max_community_levels}}{Max hierarchy depth}

\item{\code{min_community_size}}{Min entities per community}

\item{\code{relationship_threshold}}{Min relationship strength}

\item{\code{deduplicate_entities}}{Merge similar entities}

\item{\code{entity_similarity_threshold}}{Similarity for dedup}

\item{\code{search_type}}{Default search strategy}

\item{\code{local_search_k}}{Seed entities for local search}

\item{\code{global_search_k}}{Communities for global search}

\item{\code{traversal_depth}}{Max hops}

\item{\code{include_relationships}}{Include relationship context}

\item{\code{include_community_context}}{Include community summaries}

\item{\code{enable_incremental}}{Incremental updates}

\item{\code{batch_size}}{Chunks per batch}

\item{\code{use_cache}}{Cache embeddings}

\item{\code{cache_ttl}}{Cache TTL seconds}

\item{\code{entity_types}}{Types to extract}

\item{\code{relationship_types}}{Types to extract}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GraphRAGConfig-new}{\code{GraphRAGConfig$new()}}
\item \href{#method-GraphRAGConfig-with_openai}{\code{GraphRAGConfig$with_openai()}}
\item \href{#method-GraphRAGConfig-with_ollama}{\code{GraphRAGConfig$with_ollama()}}
\item \href{#method-GraphRAGConfig-clone}{\code{GraphRAGConfig$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGConfig-new"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGConfig-new}{}}}
\subsection{Method \code{new()}}{
Create a new GraphRAGConfig
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGConfig$new(enabled = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{Enable GraphRAG}

\item{\code{...}}{Additional configuration options}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGConfig-with_openai"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGConfig-with_openai}{}}}
\subsection{Method \code{with_openai()}}{
Configure for OpenAI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGConfig$with_openai(model = "gpt-4o-mini", api_key = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model name}

\item{\code{api_key}}{API key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGConfig-with_ollama"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGConfig-with_ollama}{}}}
\subsection{Method \code{with_ollama()}}{
Configure for Ollama
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGConfig$with_ollama(
  model = "llama3.2",
  endpoint = "http://localhost:11434"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{Model name}

\item{\code{endpoint}}{Endpoint URL}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GraphRAGConfig-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GraphRAGConfig-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GraphRAGConfig$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
