% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmoplot.R
\name{fitmoplot}
\alias{fitmoplot}
\alias{fitmoplot.tidal}
\alias{fitmoplot.tidalmean}
\title{Plot the fitted results for a tidal object by month}
\usage{
fitmoplot(dat_in, ...)

\method{fitmoplot}{tidal}(
  dat_in,
  month = c(1:12),
  tau = NULL,
  predicted = TRUE,
  logspace = TRUE,
  dt_rng = NULL,
  ncol = NULL,
  col_vec = NULL,
  grids = TRUE,
  pretty = TRUE,
  lwd = 1,
  size = 2,
  alpha = 1,
  ...
)

\method{fitmoplot}{tidalmean}(
  dat_in,
  month = c(1:12),
  predicted = TRUE,
  logspace = TRUE,
  dt_rng = NULL,
  ncol = NULL,
  col_vec = NULL,
  grids = TRUE,
  pretty = TRUE,
  lwd = 1,
  size = 2,
  alpha = 1,
  ...
)
}
\arguments{
\item{dat_in}{input tidal or tidalmean object}

\item{...}{arguments passed to other methods}

\item{month}{numeric indicating months to plot}

\item{tau}{numeric vector of quantiles to plot, defaults to all in object if not supplied}

\item{predicted}{logical indicating if standard predicted values are plotted, default \code{TRUE}, otherwise normalized predictions are plotted}

\item{logspace}{logical indicating if plots are in log space}

\item{dt_rng}{Optional chr string indicating the date range of the plot. Must be two values in the format 'YYYY-mm-dd' which is passed to \code{\link{as.Date}}.}

\item{ncol}{numeric argument passed to \code{\link[ggplot2]{facet_wrap}} indicating number of facet columns}

\item{col_vec}{chr string of plot colors to use, passed to \code{\link{gradcols}}.  Any color palette from RColorBrewer can be used as a named input. Palettes from grDevices must be supplied as the returned string of colors for each palette.}

\item{grids}{logical indicating if grid lines are present}

\item{pretty}{logical indicating if my subjective idea of plot aesthetics is applied, otherwise the \code{\link[ggplot2]{ggplot}} default themes are used}

\item{lwd}{numeric value indicating width of lines}

\item{size}{numeric value indicating size of points}

\item{alpha}{numeric value indicating transparency of points or lines}
}
\value{
A \code{\link[ggplot2]{ggplot}} object that can be further modified
}
\description{
Plot a tidal object to view the response variable observations, predictions, and normalized results separately for each month.
}
\details{
The plots are similar to those produced by \code{\link{fitplot}} except the values are faceted by month.  This allows an evaluation of trends over time independent of seasonal variation.  Multiple observations within each month for each year are averaged for a smoother plot.
}
\examples{

## load a fitted tidal object
data(tidfit)

# plot using defaults
fitmoplot(tidfit)
\dontrun{ 
# get the same plot but use default ggplot settings
fitmoplot(tidfit, pretty = FALSE)

# plot specific quantiles
fitmoplot(tidfit, tau = c(0.1, 0.9))

# plot the normalized predictions
fitmoplot(tidfit, predicted = FALSE)

# modify the plot as needed using ggplot scales, etc.

library(ggplot2)

fitmoplot(tidfit, pretty = FALSE, linetype = 'dashed') + 
 theme_classic() + 
 scale_y_continuous(
   'Chlorophyll', 
   limits = c(0, 5)
   ) +
 scale_colour_manual( 
   'Predictions', 
   labels = c('lo', 'md', 'hi'), 
   values = c('red', 'green', 'blue'), 
   guide = guide_legend(reverse = TRUE)
   ) 
   
# plot a tidalmean object
data(tidfitmean)

fitmoplot(tidfitmean)    
}
}
\seealso{
\code{\link{fitplot}}, \code{\link{prdnrmplot}}, \code{\link{sliceplot}}
}
